//--------------------------------------------------------------------
// demo1.cpp for I-8090 card
// This program demostrates the software 32 bits encoder method by
//   void i8090_ENCODER32_ISR(unsigned char cardNo);
//   void i8090_RESET_ENCODER32(unsigned char cardNo, unsigned char axis);
//   long i8090_GET_ENCODER32(unsigned char cardNo, unsigned char axis);
//--------------------------------------------------------------------
// v1.0  6/20/2001
//
//--------------------------------------------------------------------
#include <dos.h>
#include <math.h>
#include "8000.h"
#include "i8090.h"

#define i8090  0x0d
#define i8091  0x0e
#define i8092  0x0f
#define NOCARD 0x00

#define Insert          0x0000
#define BasePort        0x0080
#define SlotOffset      0x0020
#define IDPort          0x0000

#define CARD1  1
#define CARD2  2
#define MAX_SLOT_NO  8
unsigned int PortAddress[8]={0x080, 0x0a0, 0x0c0, 0x0e0, 0x140, 0x160, 0x180, 0x1a0};
//--------------------------------------------------------------------
long          x_value;
long          y_value;
long          z_value;
unsigned char index;
unsigned char x_index;
unsigned char y_index;
unsigned char z_index;

unsigned char i8090Slot;
//--------------------------------------------------------------------

//--------------------------------------------------------------------
void ShowLedValue(long value,unsigned char axis)
{
long j;                         
unsigned char negative_value;

  if (value<0) negative_value=1; 
  else         negative_value=0;
  value=labs(value);                          
                                            
  j=value-10*(value/10);     
  if (negative_value) Show5DigitLedWithDot(0x05, j);
  else                Show5DigitLed(0x05, j); 
  
  value=value/10;
  j=value-10*(value/10);
  Show5DigitLed(0x04, j);
  value=value/10;
  j=value-10*(value/10);
  if (axis==Z_axis) Show5DigitLedWithDot(0x03, j);
  else              Show5DigitLed(0x03, j);
  value=value/10;
  j=value-10*(value/10);
  if (axis==Y_axis) Show5DigitLedWithDot(0x02, j);
  else              Show5DigitLed(0x02, j);
  value=value/10;
  j=value-10*(value/10);
  if (axis==X_axis) Show5DigitLedWithDot(0x01, j);
  else              Show5DigitLed(0x01, j);
}
//---------------------------------------------------
void ShowCardName(unsigned char SlotNum)
{
unsigned char temp;

   Show5DigitLed(0x05, SlotNum);
   temp=inportb(PortAddress[SlotNum]);
   switch (temp)
   {
      case i8090: //i8090 3-axis encoder card
                Show5DigitLedSeg (0x01, 0x7F);
                Show5DigitLedSeg (0x02, 0x7E);
                Show5DigitLedSeg (0x03, 0x7B);
                Show5DigitLedSeg (0x04, 0x7E);
                break;
      case i8091: //i8091 2-axis stepping card
                Show5DigitLedSeg (0x01, 0x7F);
                Show5DigitLedSeg (0x02, 0x7E);
                Show5DigitLedSeg (0x03, 0x7B);
                Show5DigitLedSeg (0x04, 0x30);
                break;
      default:
                Show5DigitLedSeg (0x01, 0x01);
                Show5DigitLedSeg (0x02, 0x01);
                Show5DigitLedSeg (0x03, 0x01);
                Show5DigitLedSeg (0x04, 0x01);
                break;
   };
}
//---------------------------------------------------
unsigned char CardSearch(unsigned char SlotNum)
{
unsigned char temp;

   temp=inportb(PortAddress[SlotNum]);
   ShowCardName(SlotNum);
   switch (temp)
   {
      case i8090: //i8090 3-axis encoder card
                Print("Slot %d = i8090\r\n",SlotNum);
                return i8090;
      case i8091: //i8091 2-axis stepping card
                Print("Slot %d = i8091\r\n",SlotNum);
                return i8091;
      default:
		Print("Slot %d = No Card\r\n",SlotNum);
                return NOCARD;
   };
}

//---------------------------------------------------------------------------------
void main ()
{
unsigned char j;
int           key,ShowAxis;

  i8090Slot=99;
  for (j=0; j<MAX_SLOT_NO; j++)
  {
    if (CardSearch(j)==i8090) i8090Slot=j;
    Delay(500);
  };

  if (i8090Slot==99)
  {
     Print("Not found I-8090 card in 8 slot!\r\n");
     return;
  }

  i8090_REGISTRATION(CARD1, PortAddress[i8090Slot]);
  i8090_INIT_CARD(CARD1, ENC_QUADRANT, ENC_QUADRANT, ENC_QUADRANT);
  i8090_RESET_ENCODER(CARD1, X_axis);
  i8090_RESET_ENCODER(CARD1, Y_axis);
  i8090_RESET_ENCODER(CARD1, Z_axis);
  i8090_RESET_ENCODER32(CARD1, X_axis);
  i8090_RESET_ENCODER32(CARD1, Y_axis);
  i8090_RESET_ENCODER32(CARD1, Z_axis);

  Print("-----------------------------------------------------------------------\r\n");
  Print(" I-8090 DEMO1 program   demo1.PRJ, demo1.cpp, i8090.lib                 \r\n");
  Print(" 32 bits encoder demostration                                          \r\n");
  Print("-----------------------------------------------------------------------\r\n");
  Print("Press any key to stop...\r\n");
  ClearSystemKey();
  ShowAxis=0;
  do
  {                 
      Delay(5);   //delay 5ms                   
      //---------------------------------------------------
      // i8090_ENCODER32_ISR(CARD1) should be called in 2~10ms
      // or call it by a timer interrupt service routine by 2~10ms
      //---------------------------------------------------
      i8090_ENCODER32_ISR(CARD1);
      
      //---------------------------------------------------
      x_value = i8090_GET_ENCODER32(CARD1, X_axis);
      y_value = i8090_GET_ENCODER32(CARD1, Y_axis);
      z_value = i8090_GET_ENCODER32(CARD1, Z_axis);
      index   = i8090_GET_INDEX(CARD1);
      x_index = index & 0x01;
      y_index = (index & 0x02) >> 1;
      z_index = (index & 0x04) >> 2;

      if (IsSystemKey())
      {
	 key=GetSystemKey();
         ClearSystemKey();
         switch (key)
         {
           case SKEY_DOWN:
                         ShowAxis++;
                         if (ShowAxis>2) ShowAxis=0;
                         break;
           case SKEY_UP:
                         ShowAxis--;
			 if (ShowAxis<0) ShowAxis=2;
                         break;
         };
      }

      switch (ShowAxis)
      {
         case 0: ShowLedValue(x_value,X_axis); break;
         case 1: ShowLedValue(y_value,Y_axis); break;
         case 2: ShowLedValue(z_value,Z_axis); break;
      };
      if (x_index) LedRunOff();  else LedRunOn();
      if (y_index) LedCommOff(); else LedCommOn();
      if (z_index) LedBattOff(); else LedBattOn();
  } while (!Kbhit());
}